<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Ui\Component\MassAction\Order;

use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\UrlInterface;
use Magento\Ui\Component\MassAction;
use Amasty\Dropshipping\Helper\Data;
use Amasty\Dropshipping\Model\Config\Source\Dealers;

class Actions extends MassAction
{
    public const MASS_ACTION_URL = 'amasty_perm/massaction/Index';

    /**
     * @var Data
     */
    private $helper;

    /**
     * @var Dealers
     */
    private $dealers;

    /**
     * @var UrlInterface
     */
    private $url;

    public function __construct(
        ContextInterface $context,
        UrlInterface $url,
        Data $helper,
        Dealers $dealers,
        $components,
        array $data
    ) {
        parent::__construct($context, $components, $data);
        $this->dealers = $dealers;
        $this->helper = $helper;
        $this->url = $url;
    }

    /**
     * @inheritDoc
     */
    public function prepare()
    {
        parent::prepare();

        if (!$this->helper->getBackendDealer()->getId()) {
            $this->addDealerAction();
        }
    }

    /**
     * @inheritDoc
     */
    private function addDealerAction()
    {
        $dealerActions = [];

        $options = $this->dealers->toOptionArray();
        foreach ($options as $option) {
            $dealerActions[] = [
                'type'    => strtolower($option['label']),
                'label' => $option['label'],
                'url'   => $this->url->getUrl(
                    self::MASS_ACTION_URL,
                    $this->getUrlParams($option['value'])
                ),
                'confirm'       => [
                    'title'   => 'Assign Orders to Dealer',
                    'message' => 'Are you sure to assign selected orders to choosen dealer?'
                ]
            ];
        }
        $this->_data['config']['actions'][] = [
            'actions'       => $dealerActions,
            'component'     => 'uiComponent',
            'type'          => 'amasty_perm_assign_to_dealer',
            'label'         => 'Assign Orders to Dealer',
            'url' => self::MASS_ACTION_URL
        ];
    }

    /**
     * Prepare params array for urlBuilder
     *
     * @param string|int $optionValue
     *
     * @return array
     */
    public function getUrlParams($optionValue)
    {
        return ['dealer' => $optionValue];
    }
}
