<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Setup;

use Amasty\Dropshipping\Model\DealerItem\ResourceModel\DealerItem;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UninstallInterface;

class Uninstall implements UninstallInterface
{
    /**
     * @param SchemaSetupInterface   $setup
     * @param ModuleContextInterface $context
     */
    public function uninstall(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $defaultConnection = $setup->getConnection(ResourceConnection::DEFAULT_CONNECTION);
        $defaultConnection->dropTable($setup->getTable(DealerItem::TABLE_NAME));
        $defaultConnection->dropTable($setup->getTable('amasty_perm_dealer_order_assign_history'));
        $defaultConnection->dropTable($setup->getTable('amasty_perm_dealer_order'));
        $defaultConnection->dropTable($setup->getTable('amasty_perm_dealer_customer'));
        $defaultConnection->dropTable($setup->getTable('amasty_perm_dealer'));
        $defaultConnection->dropTable($setup->getTable('amasty_perm_role'));
        $defaultConnection->delete(
            $setup->getTable('core_config_data'),
            "`path` LIKE 'amasty_dropshipping/%'"
        );
    }
}
