<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */
namespace Amasty\Dropshipping\Plugin;

use Amasty\Dropshipping\Helper\Data as PermHelper;
use Magento\Sales\Model\Order;
use Magento\Sales\Model\Order\Email\Sender\OrderSender;

class OrderEmailSenderOrderSender
{
    /**
     * @var PermHelper
     */
    protected $_permHelper;

    public function __construct(
        PermHelper $permHelper
    ) {
        $this->_permHelper = $permHelper;
    }

    public function beforeSend(
        OrderSender $orderSender,
        Order $order,
        $forceSyncMode = false
    ) {
        $this->_permHelper->loadDealers($order);
    }
}
