<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */
namespace Amasty\Dropshipping\Plugin;

use Amasty\Dropshipping\Helper\Data as PermHelper;
use Amasty\Dropshipping\Model\ConfigProvider;
use Magento\Sales\Model\Order\Email\Container\OrderIdentity;

class OrderEmailContainerOrderIdentity
{
    /**
     * @var PermHelper
     */
    protected $_permHelper;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        PermHelper $permHelper,
        ConfigProvider $configProvider
    ) {
        $this->_permHelper = $permHelper;
        $this->configProvider = $configProvider;
    }

    public function afterGetEmailCopyTo(
        OrderIdentity $orderIdentity,
        $data
    ) {
        if ($this->configProvider->isNotifyEnabled() && $this->_permHelper->hasDealers()) {
            if (!is_array($data)) {
                $data = [];
            }

            foreach ($this->_permHelper->getDealers() as $dealer) {
                $emails = $dealer->getAllEmails();
                if (is_array($emails) && count($emails) > 0) {
                    //phpcs:ignore
                    $data = array_merge($data, $emails);
                }
            }
        }

        return $data;
    }
}
