<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */
namespace Amasty\Dropshipping\Plugin;

use Amasty\Dropshipping\Helper\Data as PermHelper;
use Amasty\Dropshipping\Model\ResourceModel\DealerCustomer\CollectionFactory as DealerCustomerCollectionFactory;

class OrderCustomerCollection
{
    /**
     * @var bool
     */
    protected $_collectionModified = false;

    /**
     * @var PermHelper
     */
    protected $_permHelper;

    /**
     * @var DealerCustomerCollectionFactory
     */
    protected $_dealerCustomerCollectionFactory;

    public function __construct(
        DealerCustomerCollectionFactory $dealerCustomerCollectionFactory,
        PermHelper $permHelper
    ) {
        $this->_dealerCustomerCollectionFactory = $dealerCustomerCollectionFactory;
        $this->_permHelper = $permHelper;
    }

    public function beforeLoad(
        \Magento\Sales\Model\ResourceModel\Order\Customer\Collection $collection
    ) {
        if (!$collection->isLoaded() && !$this->_collectionModified) {
            if ($this->_permHelper->isBackendDealer() && !$this->_permHelper->isAllowAllCustomersCreateOrders()) {
                $dealerCustomerCollection = $this->_dealerCustomerCollectionFactory->create()
                    ->addFieldToFilter('dealer_id', $this->_permHelper->getBackendDealer()->getId());

                $collection->addFieldToFilter(
                    'entity_id',
                    ['in' => $dealerCustomerCollection->getCustomersIds()]
                );
            }

            $this->_collectionModified = true;
        }
    }
}
