<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Plugin\Model\Service;

use Amasty\Dropshipping\Helper\Data;
use Amasty\Dropshipping\Model\DealerItem\ResourceModel\DealerItem;
use Magento\Sales\Model\Order;

class InvoiceServicePlugin
{
    /**
     * @var Data
     */
    private $permHelper;

    /**
     * @var DealerItem
     */
    private $dealerItemResource;

    public function __construct(
        Data $permHelper,
        DealerItem $dealerItemResource
    ) {
        $this->permHelper = $permHelper;
        $this->dealerItemResource = $dealerItemResource;
    }

    /**
     * @param ProductAction $subject
     * @param array $productIds
     * @param array $attrData
     * @param int $storeId
     *
     * @return array
     */
    public function beforePrepareInvoice($servise, $order, $qty = [])
    {
        if (is_array($qty) && !empty($qty)) {
            return [$order, $qty];
        }
        $dealer = $this->permHelper->getBackendDealer();
        if ($dealerId = $dealer->getId()) {
            $allowedItems = $this->dealerItemResource->getOrderItemsByDealer($dealerId);
            foreach ($order->getItems() as $item) {
                if (!in_array($item->getId(), $allowedItems)) {
                    $qty[$item->getId()] = 0;
                } else {
                    $qty[$item->getId()] = $item->getQtyOrdered() - $item->getQtyInvoiced();
                }
            }
        } else {
            foreach ($order->getItems() as $item) {
                $qty[$item->getId()] = $item->getQtyOrdered() - $item->getQtyInvoiced();
            }
        }

        return [$order, $qty];
    }
}
