<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Plugin\Model\Repository;

use Amasty\AdvancedMSI\Model\Repository\ReservedProductsRepository;
use Amasty\Dropshipping\Model\DealerItem\ResourceModel\DealerItem;
use Amasty\Dropshipping\Helper\Data as PermHelper;
use Magento\Sales\Model\OrderRepository;

class ReservedProducts
{
    /**
     * @var DealerItem
     */
    private $dealerItemResource;

    /**
     * @var PermHelper
     */
    private $permHelper;

    /**
     * @var OrderRepository
     */
    private $orderRepository;

    public function __construct(
        DealerItem $dealerItemResource,
        PermHelper $permHelper,
        OrderRepository $orderRepository
    ) {
        $this->dealerItemResource = $dealerItemResource;
        $this->permHelper = $permHelper;
        $this->orderRepository = $orderRepository;
    }

    /**
     * @param ReservedProductsRepository $subject
     * @param array $result
     * @param $orderId
     *
     * @return array
     * @throws \Magento\Framework\Exception\InputException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function afterGetByOrderId(
        ReservedProductsRepository $subject,
        array $result,
        $orderId
    ) {
        $dealer = $this->permHelper->getBackendDealer();

        if ($dealerId = $dealer->getId()) {
            $allowedItems = $this->dealerItemResource->getOrderItemsByDealer($dealerId);
            $order = $this->orderRepository->get($orderId);

            foreach ($order->getItems() as $item) {
                if (!in_array($item->getId(), $allowedItems)) {
                    foreach ($result as $key => $resultItem) {
                        if ($item->getSku() === $resultItem->getSku()) {
                            unset($result[$key]);
                        }
                    }
                }
            }
        }

        return $result;
    }
}
