<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Plugin;

use Amasty\Dropshipping\Helper\Data as DropHelper;
use Magento\Customer\Model\Customer\Attribute\Source\Group;

class CustomerAttributeSourceGroup
{
    /**
     * @var DropHelper
     */
    protected $dropHelper;

    public function __construct(
        DropHelper $dropHelper
    ) {
        $this->dropHelper = $dropHelper;
    }

    /**
     * @param Group $group
     * @param array $options
     *
     * @return array
     */
    public function afterGetAllOptions(
        Group $group,
        $options
    ) {
        if ($this->dropHelper->isBackendDealer()) {
            $dealerGroups = $this->dropHelper->getBackendDealer()->getCustomerGroups();

            if (count($dealerGroups) > 0) {
                if (!empty($options[0]) && is_array($options[0]['value'])) {
                    $newOptions = $this->prepareOptions($options[0]['value'], $dealerGroups);
                    $options[0]['value'] = $newOptions;
                } else {
                    $newOptions = $this->prepareOptions($options, $dealerGroups);
                    $options = $newOptions;
                }
            }
        }

        return $options;
    }

    /**
     * @param array $options
     * @param array $dealerGroups
     *
     * @return array
     */
    private function prepareOptions($options, $dealerGroups)
    {
        $newOptions = [];

        foreach ($options as $option) {
            if (in_array($option['value'], $dealerGroups)) {
                $newOptions[] = $option;
            }
        }

        return $newOptions;
    }
}
