<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Plugin\Block\Adminhtml\Order\View\Items\Renderer;

use Amasty\Dropshipping\Model\DealerItem\DealerItemRepository;
use Amasty\Dropshipping\Model\DealerItem\Notified\Statuses;
use Magento\Framework\DataObject;
use Magento\Sales\Block\Adminhtml\Order\View\Items\Renderer\DefaultRenderer;

class NotifiedRendererPlugin
{
    /**
     * @var DealerItemRepository
     */
    private $dealerItemRepository;

    /**
     * @var Statuses
     */
    private $statuses;

    public function __construct(
        DealerItemRepository $dealerItemRepository,
        Statuses $statuses
    ) {
        $this->dealerItemRepository = $dealerItemRepository;
        $this->statuses = $statuses;
    }

    public function aroundGetColumnHtml(
        DefaultRenderer $defaultRenderer,
        \Closure $proceed,
        DataObject $item,
        $column,
        $field = null
    ) {
        if ($column === 'notified') {
            $dealerOrderItem = $this->dealerItemRepository->getByOrderItemId($item->getItemId());
            $notified = $dealerOrderItem->getNotifyStatus() ?
                $dealerOrderItem->getNotifyStatus() :
                Statuses::NOT_NOTIFIED;
            $notifiedLabel = $this->statuses->toArray()[$notified] ?? '';
            $result = '<span class="amasty_order_item_id' . $item->getItemId() . '">' . $notifiedLabel . '</span>';
        } else {
            $result = $proceed($item, $column, $field);
        }

        return $result;
    }
}
