<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Plugin\Block\Adminhtml\Order\View\Items\Renderer;

use Magento\Sales\Block\Adminhtml\Order\View\Items\Renderer\DefaultRenderer;
use Magento\Framework\DataObject;
use Magento\Backend\Model\Auth\Session;
use Amasty\Dropshipping\Model\DealerFactory;
use Amasty\Dropshipping\Model\ResourceModel\Dealer;

class DealerRendererPlugin
{
    /**
     * @var DealerFactory
     */
    private $dealerFactory;

    /**
     * @var Dealer
     */
    private $dealer;

    /**
     * @var Session
     */
    private $authSession;

    public function __construct(
        Session $authSession,
        DealerFactory $dealerFactory,
        Dealer $dealer
    ) {
        $this->dealerFactory = $dealerFactory;
        $this->dealer = $dealer;
        $this->authSession = $authSession;
    }

    public function aroundGetColumnHtml(
        DefaultRenderer $defaultRenderer,
        \Closure $proceed,
        DataObject $item,
        $column,
        $field = null
    ) {
        $dealerModel = $this->dealerFactory->create();
        $this->dealer->load($dealerModel, $this->authSession->getUser()->getId(), 'user_id');

        if ($column === 'dealers'
            && is_object($dealerModel)
            && (!$dealerModel->getId() || !$dealerModel->getRoleId())
        ) {
            $result = $defaultRenderer->getLayout()->getBlock('column_dealers')
                ->setOrderItemId($item->getId())
                ->toHtml();

            $orderItemsIds = array_keys(
                $defaultRenderer->getOrder()->getItemsCollection([], true)->getItems()
            );
            $lastOrderItem = array_pop($orderItemsIds);
            if ($lastOrderItem == $item->getId()) {
                // added button if item is last
                $result .= $defaultRenderer->getLayout()->getBlock('assign_dealers')->toHtml();
            }
        } elseif ($column === 'dealers' && $dealerModel->getId()) {
            $result = __('Assigned to you');
        } else {
            $result = $proceed($item, $column, $field);
        }

        return $result;
    }
}
