<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Plugin\Block\Adminhtml\Order\View\Items;

use Amasty\Dropshipping\Helper\Data;
use Amasty\Dropshipping\Model\DealerItem\ResourceModel\DealerItem;

class GetItemsPlugin
{
    /**
     * @var Data
     */
    private $permHelper;

    /**
     * @var DealerItem
     */
    private $dealerItemResource;

    public function __construct(
        Data $permHelper,
        DealerItem $dealerItemResource
    ) {
        $this->permHelper = $permHelper;
        $this->dealerItemResource = $dealerItemResource;
    }

    /**
     * Hided not allowed items
     *
     * @param \Magento\Framework\DataObject $subject
     * @param array $result
     * @param mixed $item
     * @return string
     */
    public function afterGetItemHtml(\Magento\Framework\DataObject $subject, $result, $item)
    {
        $dealer = $this->permHelper->getBackendDealer();
        if ($dealerId = $dealer->getId()) {
            $allowedItems = $this->dealerItemResource->getOrderItemsByDealer($dealerId);
            if ($item->getOrderItemId()) {
                // getting itemId on invoice page
                $itemId = $item->getOrderItemId();
            } else {
                // getting itemId on order view page
                $itemId = $item->getId();
            }
            if (!in_array($itemId, $allowedItems)) {
                return '';
            }
        }

        return $result;
    }
}
