<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */
namespace Amasty\Dropshipping\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Amasty\Dropshipping\Helper\Data;
use Amasty\Dropshipping\Model\DealerItem\ResourceModel\DealerItem;

class SalesOrderLoadAfterObserver implements ObserverInterface
{
    /**
     * @var Data
     */
    private $permHelper;

    /**
     * @var DealerItem
     */
    private $dealerItemResource;

    public function __construct(
        Data $permHelper,
        DealerItem $dealerItemResource
    ) {
        $this->permHelper = $permHelper;
        $this->dealerItemResource = $dealerItemResource;
    }

    public function execute(Observer $observer)
    {
        $canInvoiceForDealer = false;
        $order = $observer->getEvent()->getData('data_object');
        $dealer = $this->permHelper->getBackendDealer();
        if ($dealerId = $dealer->getId()) {
            $allowedItems = $this->dealerItemResource->getOrderItemsByDealer($dealerId);
            foreach ($order->getItems() as $item) {
                /** @var \Magento\Sales\Model\Order\Item $item */
                if (!in_array($item->getId(), $allowedItems)) {
                    $item->setLockedDoShip(true);
                } else {
                    if (!$this->isLastItem($item)) {
                        $canInvoiceForDealer = true;
                    }
                    $item->setLockedDoShip(false);
                }
            }

            if (!$canInvoiceForDealer) {
                foreach ($order->getItems() as $item) {
                    $item->setLockedDoInvoice(true);
                }
            }
        } else {
            // unlock all items for admin
            foreach ($order->getItems() as $item) {
                $item->setLockedDoInvoice(false);
                $item->setLockedDoShip(false);
            }
        }

        $this->permHelper->checkPermissionsByOrder($order);
    }

    /**
     * Checking if the item is last
     *
     * @param \Magento\Sales\Model\Order\Item $item
     *
     * @return bool
     */
    public function isLastItem($item)
    {
        if ((int)$item->getQtyToInvoice() <= 0) {
            return true;
        }

        return false;
    }
}
