<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Magento\Sales\Model\Order;

class OrderSaveAfter implements ObserverInterface
{
    /**
     * @param Observer $observer
     */
    public function execute(Observer $observer)
    {
        $order = $observer->getData('order');
        // unlock all items before order place for correct check canShip and canInvoice
        foreach ($order->getItems() as $item) {
            $item->setLockedDoInvoice(false);
            $item->setLockedDoShip(false);
        }
        /** @var \Magento\Sales\Model\Order $order */
        if ($order->getState() === Order::STATE_COMPLETE && ($order->canShip() || $order->canInvoice())) {
            $order->setState($order->getOrigData('state'));
            $order->setStatus($order->getOrigData('status'));
        }
    }
}
