<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */
namespace Amasty\Dropshipping\Observer;

use Amasty\Dropshipping\Model\DealerCustomerFactory;
use Magento\Framework\Event\ObserverInterface;

class CustomerSaveAfterObserver implements ObserverInterface
{
    /**
     * @var \Amasty\Dropshipping\Helper\Data
     */
    protected $_permHelper;

    /**
     * @var \Magento\Framework\App\Request\Http
     */
    protected $_request;

    /**
     * @var \Amasty\Dropshipping\Model\DealerFactory
     */
    protected $_dealerFactory;

    /**
     * @var DealerCustomerFactory
     */
    protected $dealerCustomerFactory;

    /**
     * @param \Amasty\Dropshipping\Helper\Data $permHelper
     * @param \Magento\Framework\App\Request\Http $request
     * @param \Amasty\Dropshipping\Model\DealerFactory $dealerFactory
     */
    public function __construct(
        \Amasty\Dropshipping\Helper\Data $permHelper,
        \Magento\Framework\App\Request\Http $request,
        \Amasty\Dropshipping\Model\DealerFactory $dealerFactory,
        DealerCustomerFactory $dealerCustomerFactory
    ) {
        $this->_permHelper = $permHelper;
        $this->_request = $request;
        $this->_dealerFactory = $dealerFactory;
        $this->dealerCustomerFactory = $dealerCustomerFactory;
    }

    /**
     * @param \Magento\Framework\Event\Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $dealerId = null;

        $amastyPermData = $this->_request->getParam('amasty_perm'); //customer registration form frontend
        $customerData = $this->_request->getParam('customer'); //customer edit on backend

        if ($amastyPermData && array_key_exists('dealer_id', $amastyPermData)) {
            $dealerId = $amastyPermData['dealer_id'];
        } elseif ($customerData && array_key_exists('amasty_perm_dealer', $customerData)) {
            $dealerId = $customerData['amasty_perm_dealer'];
        } elseif ($this->_permHelper->isBackendDealer()) {
            $dealerId = $this->_permHelper->getBackendDealer()->getId();
        }

        if ($dealerId !== null) {

            $customer = $observer->getEvent()->getData('data_object');

            if (!$customer) {
                $customer = $observer->getEvent()->getData('customer_data_object');
            }

            $dealer = $this->_dealerFactory->create()->load($dealerId);
            if ($dealer->getId()) {
                $dealer->saveCustomers([$customer->getId()], false);
            } else {
                $dealerCustomer = $this->dealerCustomerFactory->create()->load($customer->getId(), 'customer_id');
                if ($dealerCustomer->getId()) {
                    $dealerCustomer->delete();
                }
            }
        }
    }
}
