<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */
namespace Amasty\Dropshipping\Observer;

use Magento\Framework\Event\ObserverInterface;

class AdminUserSaveAfterObserver implements ObserverInterface
{
    /**
     * @var \Amasty\Dropshipping\Model\DealerFactory
     */
    protected $_dealerFactory;

    /**
     * @var \Amasty\Dropshipping\Model\RoleFactory
     */
    protected $_roleFactory;

    /**
     * @var \Magento\Framework\App\Request\Http
     */
    protected $_request;

    public function __construct(
        \Amasty\Dropshipping\Model\DealerFactory $dealerFactory,
        \Amasty\Dropshipping\Model\RoleFactory $roleFactory,
        \Magento\Framework\App\Request\Http $request
    ) {
        $this->_dealerFactory = $dealerFactory;
        $this->_roleFactory = $roleFactory;
        $this->_request = $request;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $user = $observer->getEvent()->getData('data_object');

        if ($user) {
            $dealer = $this->_dealerFactory->create()->load($user->getId(), 'user_id');
            $role = $this->_roleFactory->create()
                ->load($user->getRole()->getId(), 'role_id');

            if ($role->getId()) {

                $data = [];
                if ($perm = $this->_request->getParam('amasty_perm')) {
                    $data = $perm;
                    if (isset($data['customer_group_ids']) && is_array($data['customer_group_ids'])) {
                        $data['customer_group_ids'] = implode(',', $data['customer_group_ids']);
                    } else {
                        $data['customer_group_ids'] = '';
                    }
                }

                $dealer->addData(array_merge([
                    'user_id' => $user->getId(),
                    'role_id' => $role->getId()
                ], $data));

                $dealer->save();

                if (array_key_exists('in_dealer_customer', $data)) {
                    $customersIds = $data['in_dealer_customer'];
                    // phpcs:ignore Magento2.Functions.DiscouragedFunction
                    parse_str($customersIds, $customersIds);
                    $customersIds = array_keys($customersIds);

                    $dealer->saveCustomers($customersIds);
                }
            }
        }
    }
}
