<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */
namespace Amasty\Dropshipping\Model\ResourceModel\DealerOrder;

class Collection extends \Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection
{
    protected function _construct()
    {
        parent::_construct();
        $this->_init(
            \Amasty\Dropshipping\Model\DealerOrder::class,
            \Amasty\Dropshipping\Model\ResourceModel\DealerOrder::class
        );
        $this->_setIdFieldName($this->getResource()->getIdFieldName());
    }

    public function addDealersToSelect(array $ordersIds)
    {
        if (count($ordersIds) > 0) {
            $this->addFieldToFilter('main_table.order_id', ['in' => $ordersIds]);
        }

        return $this;
    }

    public function getDealersIds()
    {
        $ids = [];
        foreach ($this->getItems() as $dealerCustomer) {
            $ids[] = $dealerCustomer->getDealerId();
        }
        return $ids;
    }
}
