<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */
namespace Amasty\Dropshipping\Model\ResourceModel;

class DealerOrder extends \Magento\Framework\Model\ResourceModel\Db\AbstractDb
{
    protected function _construct()
    {
        $this->_init('amasty_perm_dealer_order', 'entity_id');
    }

    /**
     * Clean by order id
     *
     * @param int $orderId
     *
     * @return int
     */
    public function cleanByOrderId($orderId)
    {
        $connection = $this->getConnection();
        $tableName = $this->getMainTable();
        $connection->delete($tableName, ['order_id = ?' => (int)$orderId]);
    }
}
