<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Model\ResourceModel;

use Amasty\Dropshipping\Helper\Data;

class DealerCustomer extends \Magento\Framework\Model\ResourceModel\Db\AbstractDb
{
    /**
     * @var Data
     */
    private $_helper;

    public function __construct(
        \Magento\Framework\Model\ResourceModel\Db\Context $context,
        \Amasty\Dropshipping\Helper\Data $helper,
        $connectionName = null
    ) {
        $this->_helper = $helper;

        return parent::__construct($context, $connectionName);
    }
    protected function _construct()
    {
        $this->_init('amasty_perm_dealer_customer', 'entity_id');
    }

    public function getCustomers(\Amasty\Dropshipping\Model\Dealer $dealer)
    {
        $connection = $this->getConnection();

        $binds = ['dealer_id' => $dealer->getId()];

        $select = $connection->select()
            ->from($this->getMainTable(), ['customer_id'])
            ->where('dealer_id = :dealer_id');

        return $connection->fetchCol($select, $binds);
    }
}
