<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */
namespace Amasty\Dropshipping\Model\DealerOrder;

use Amasty\Dropshipping\Model\ConfigProvider;
use Amasty\Dropshipping\Model\Mailer;

class AssignHistory extends \Magento\Framework\Model\AbstractModel
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        ConfigProvider $configProvider,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        $this->configProvider = $configProvider;
        return parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    protected function _construct()
    {
        $this->_init(\Amasty\Dropshipping\Model\ResourceModel\DealerOrder\AssignHistory::class);
    }

    public function isDealerChanged()
    {
        return $this->getFromDealerId() != $this->getToDealerId();
    }

    public function getAdminContactname(): string
    {
        return $this->configProvider->getAdminName();
    }

    public function getAuthorDealerContactname()
    {
        return $this->getAuthorDealerId() ? parent::getAuthorDealerContactname() : $this->getAdminContactname();
    }

    public function getFromDealerContactname()
    {
        return $this->getFromDealerId() ? parent::getFromDealerContactname() : $this->getAdminContactname();
    }

    public function getToDealerContactname()
    {
        return $this->getToDealerId() ? parent::getToDealerContactname() : $this->getAdminContactname();
    }
}
