<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */
namespace Amasty\Dropshipping\Model;

use Amasty\Dropshipping\Helper\Data as PermHelper;
use Amasty\Dropshipping\Model\DealerOrder\AssignHistory;
use Amasty\Dropshipping\Model\DealerOrder\AssignHistoryFactory;
use Magento\Store\Model\Store;

class DealerOrder extends \Magento\Framework\Model\AbstractModel
{
    /** @var AssignHistoryFactory  */
    protected $_assignHistoryFactory;

    /** @var DealerFactory  */
    protected $_dealerFactory;

    /** @var  Dealer */
    protected $_dealer;

    /** @var PermHelper  */
    protected $_permHelper;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        AssignHistoryFactory $assignHistoryFactory,
        DealerFactory $dealerFactory,
        PermHelper $permHelper,
        ConfigProvider $configProvider,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        $this->_assignHistoryFactory = $assignHistoryFactory;
        $this->_dealerFactory = $dealerFactory;
        $this->_permHelper = $permHelper;
        $this->configProvider = $configProvider;
        parent::__construct(
            $context,
            $registry,
            $resource,
            $resourceCollection,
            $data
        );
    }

    protected function _construct()
    {
        $this->_init(\Amasty\Dropshipping\Model\ResourceModel\DealerOrder::class);
    }

    /**
     * @param $comment
     * @param $orderId
     * @param $toDealerId
     * @return AssignHistory
     */
    public function addDealerHistoryComment($comment, $orderId, $toDealerId)
    {
        if (!$toDealerId) {
            $toDealerId = $this->_permHelper->getBackendDealerId();
        }
        $dealer = $this->_dealerFactory->create()->load($toDealerId);
        if (!$dealer->checkPermissions()) {
            $dealer = $this->_dealerFactory->create(); //assign to admin
        }

        $history = $this->_assignHistoryFactory->create()
            ->setParentId($orderId)
            ->setToDealerId($dealer->getId())
            ->setToDealerContactname($dealer->getContactname())
            ->setFromDealerId($this->getDealer()->getId())
            ->setFromDealerContactname($this->getDealer()->getContactname())
            ->setComment($comment);

        if ($this->_permHelper->isBackendDealer()) {
            $history->setAuthorDealerId($this->_permHelper->getBackendDealer()->getId());
            $history->setAuthorDealerContactname($this->_permHelper->getBackendDealer()->getContactname());
        }

        $this->setOrderId($orderId);
        $this->setDealerId($dealer->getId());
        $this->setContactname($dealer->getContactname());

        return $history;
    }

    public function getDealer(
        int $storeId = Store::DEFAULT_STORE_ID,
        bool $forceReload = false
    ): Dealer {
        if ($this->_dealer === null || $forceReload) {
            $dealer = $this->_dealerFactory->create()->load($this->getDealerId());
            if ($dealer->checkPermissions()) {
                $this->_dealer = $dealer;
            } else {
                $this->_dealer = $this->_dealerFactory->create()
                    ->setContactname($this->configProvider->getAdminName($storeId))
                    ->setEmails($this->configProvider->getAdminEmails($storeId));
            }
        }
        return $this->_dealer;
    }

    /**
     * @param int $dealerId
     * @param int $orderId
     *
     * @return mixed
     */
    public function getAssignHistoryCollection($dealerId, $orderId)
    {
        $collection = $this->_assignHistoryFactory->create()
            ->getCollection()
            ->setOrder('created_at', 'desc')
            ->setOrder('entity_id', 'desc')
            ->addFieldToFilter('parent_id', $orderId)
            ->addFieldToFilter('to_dealer_id', $dealerId);

        return $collection;
    }
}
