<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Model\DealerItem\ResourceModel;

use Amasty\Dropshipping\Api\Data\DealerItemInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

class DealerItem extends AbstractDb
{
    public const TABLE_NAME = 'amasty_perm_dealer_order_item';

    protected function _construct()
    {
        $this->_init(self::TABLE_NAME, DealerItemInterface::ENTITY_ID);
    }

    /**
     * @param int $dealerId
     *
     * @return array
     */
    public function getOrderItemsByDealer($dealerId)
    {
        $allowedOrderItemIds = [];
        $allowedItemsSelect = $this->getConnection()->select()->from($this->getMainTable())
            ->where('dealer_id = ?', (int)$dealerId);

        $allowedItems = $this->getConnection()->fetchAll($allowedItemsSelect);

        foreach ($allowedItems as $item) {
            $allowedOrderItemIds[] = $item[DealerItemInterface::ORDER_ITEM_ID];
        }

        return $allowedOrderItemIds;
    }

    /**
     * @param int $orderItemId
     *
     * @return int
     */
    public function getDealerIdByItemId($orderItemId)
    {
        $allowedItemsSelect = $this->getConnection()->select()->from($this->getMainTable())
            ->where('order_item_id = ?', (int)$orderItemId)->columns([DealerItemInterface::DEALER_ID]);
        $dealerItemData = (array)$this->getConnection()->fetchRow($allowedItemsSelect);

        return (int)($dealerItemData[DealerItemInterface::DEALER_ID] ?? null);
    }

    /**
     * @param int $itemId
     */
    public function cleanByOrderItemId($itemId)
    {
        $connection = $this->getConnection();
        $tableName = $this->getMainTable();
        $connection->delete($tableName, ['order_item_id = ?' => (int)$itemId]);
    }

    /**
     * @param array  $orderItemIds
     * @param string $status
     *
     * @throws LocalizedException
     */
    public function updateNotifyStatus($orderItemIds, $status)
    {
        $connection = $this->getConnection();
        $tableName = $this->getMainTable();
        $connection->update(
            $tableName,
            [DealerItemInterface::NOTIFIED => $status],
            ['order_item_id IN (?)' => $orderItemIds]
        );
    }
}
