<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Model\DealerItem\Notified;

use Magento\Framework\Data\OptionSourceInterface;

class Statuses implements OptionSourceInterface
{
    public const NOTIFIED = 'yes';
    public const NOT_NOTIFIED = 'no';
    public const FAILED = 'failed';

    public function toArray()
    {
        return [
            self::NOTIFIED => __('Yes'),
            self::NOT_NOTIFIED => __('No'),
            self::FAILED => __('Failed')
        ];
    }

    /**
     * @return array
     */
    public function toOptionArray()
    {
        $optionArray = [];
        $options = $this->toArray();
        foreach ($options as $value => $label) {
            $optionArray[] = [
                'value' => $value,
                'label' => $label
            ];
        }

        return $optionArray;
    }
}
