<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Model\DealerItem;

use Magento\Framework\Model\AbstractModel;
use Amasty\Dropshipping\Api\Data\DealerItemInterface;

class DealerItem extends AbstractModel implements DealerItemInterface
{
    public function _construct()
    {
        parent::_construct();
        $this->_init(\Amasty\Dropshipping\Model\DealerItem\ResourceModel\DealerItem::class);
        $this->setIdFieldName(DealerItemInterface::ENTITY_ID);
    }

    public function getEntityId()
    {
        return $this->_getData(DealerItemInterface::ENTITY_ID);
    }

    public function setEntityId($entityId)
    {
        $this->setData(DealerItemInterface::ENTITY_ID, $entityId);

        return $this;
    }

    public function getDealerId()
    {
        return $this->_getData(DealerItemInterface::DEALER_ID);
    }

    public function setDealerId($dealerId)
    {
        $this->setData(DealerItemInterface::DEALER_ID, $dealerId);

        return $this;
    }

    public function getOrderItemId()
    {
        return $this->_getData(DealerItemInterface::ORDER_ITEM_ID);
    }

    public function setOrderItemId($orderItemId)
    {
        $this->setData(DealerItemInterface::ORDER_ITEM_ID, $orderItemId);

        return $this;
    }

    public function getNotifyStatus()
    {
        return $this->_getData(DealerItemInterface::NOTIFIED);
    }

    public function setNotifyStatus($notified)
    {
        $this->setData(DealerItemInterface::NOTIFIED, $notified);

        return $this;
    }
}
