<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */
namespace Amasty\Dropshipping\Model;

use Amasty\Dropshipping\Model\DealerCustomerFactory;
use Amasty\Dropshipping\Model\DealerFactory;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;

class DealerCustomer extends \Magento\Framework\Model\AbstractModel
{
    /** @var  Dealer */
    protected $_dealer;

    /** @var \Amasty\Dropshipping\Model\DealerFactory  */
    protected $_dealerFactory;

    /**
     * @param Context $context
     * @param Registry $registry
     * @param \Amasty\Dropshipping\Model\DealerFactory $dealerFactory
     * @param AbstractResource|null $resource
     * @param AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        DealerFactory $dealerFactory,
        AbstractResource $resource = null,
        AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        $this->_dealerFactory = $dealerFactory;

        return parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    /**
     * Model construct that should be used for object initialization
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(\Amasty\Dropshipping\Model\ResourceModel\DealerCustomer::class);
    }

    /**
     * @param \Amasty\Dropshipping\Model\Dealer $dealer
     * @return mixed
     */
    public function getCustomers(Dealer $dealer)
    {
        return $this->getResource()->getCustomers($dealer);
    }

    /**
     * @return mixed
     */
    public function dealerCustomerExists()
    {
        return $this->getResource()->dealerCustomerExists($this);
    }

    /**
     * @return mixed
     */
    public function deleteFromDealer()
    {
        return $this->getResource()->deleteFromDealer($this);
    }

    /**
     * @return string
     */
    public function getKey()
    {
        return $this->getCustomerId() . '_' . $this->getDealerId();
    }

    /**
     * @return $this|\Amasty\Dropshipping\Model\Dealer
     */
    public function getDealer()
    {
        if ($this->_dealer === null) {
            $this->_dealer = $this->_dealerFactory->create()->load($this->getDealerId());
        }
        return $this->_dealer;
    }
}
