<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Model;

use Amasty\Base\Model\ConfigProviderAbstract;
use Magento\Framework\Exception\LocalizedException;

class ConfigProvider extends ConfigProviderAbstract
{
    public const MESSAGES_ASSIGN_TEMPLATE = 'messages/assign_template';
    public const MESSAGES_COMMENT_TEMPLATE = 'messages/comment_template';
    public const MESSAGES_ENABLED = 'messages/enabled';
    public const MESSAGES_IDENTIFY = 'messages/identity';
    public const MESSAGES_ADMIN_NAME = 'messages/admin_name';
    public const MESSAGES_ADMIN_EMAIL = 'messages/admin_email';
    public const MESSAGES_COPY_TO = 'messages/copy_to';

    /**
     * @var string
     */
    protected $pathPrefix = 'amasty_dropshipping/';

    public function getAssignTemplateId(?int $storeId = null): string
    {
        return (string)$this->getValue(self::MESSAGES_ASSIGN_TEMPLATE, $storeId);
    }

    public function getCommentTemplateId(?int $storeId = null): string
    {
        return (string)$this->getValue(self::MESSAGES_COMMENT_TEMPLATE, $storeId);
    }

    public function isNotifyEnabled(?int $storeId = null): bool
    {
        return $this->isSetFlag(self::MESSAGES_ENABLED, $storeId);
    }

    public function getEmailsSenderIdentity(?int $storeId = null): string
    {
        return (string)$this->getValue(self::MESSAGES_IDENTIFY, $storeId);
    }

    public function getAdminName(?int $storeId = null): string
    {
        return (string)$this->getValue(self::MESSAGES_ADMIN_NAME, $storeId);
    }

    public function getAdminEmails(?int $storeId = null): array
    {
        $configData = $this->getValue(self::MESSAGES_ADMIN_EMAIL, $storeId);
        $adminEmails = $configData ? $this->prepareEmailsData($configData) : [];

        if (!$adminEmails) {
            throw new LocalizedException(
                __('Please enter a valid email addresses in Admin Email setting field.')
            );
        }

        return $adminEmails;
    }

    public function getEmailCopyTo(?int $storeId = null): array
    {
        $configData = $this->getValue(self::MESSAGES_COPY_TO, $storeId);
        $emails = $configData ? $this->prepareEmailsData($configData) : [];

        return $emails;
    }

    private function prepareEmailsData(string $emailsData): array
    {
        $emails = array_map('trim', explode(',', $emailsData));
        $emails = array_filter(
            $emails,
            function ($email) {
                return $email && filter_var($email, FILTER_VALIDATE_EMAIL);
            }
        );

        return $emails;
    }
}
