<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Model\Config\Source\Email;

use Magento\Email\Model\ResourceModel\Template\CollectionFactory;
use Magento\Email\Model\Template\Config;
use Magento\Framework\Data\OptionSourceInterface;
use Magento\Framework\DataObject;
use Magento\Framework\Registry;

abstract class Template extends DataObject implements OptionSourceInterface
{
    /**
     * @var Registry
     */
    protected $_coreRegistry;

    /**
     * @var Config
     */
    protected $_emailConfig;

    /**
     * @var CollectionFactory
     */
    protected $_templatesFactory;

    public function __construct(
        CollectionFactory $templatesFactory,
        Registry $coreRegistry,
        Config $emailConfig,
        array $data = []
    ) {
        parent::__construct($data);
        $this->_templatesFactory = $templatesFactory;
        $this->_coreRegistry = $coreRegistry;
        $this->_emailConfig = $emailConfig;
    }

    abstract protected function getTemplateId(): string;

    public function toOptionArray()
    {
        $templateId = $this->getTemplateId();

        $collection = $this->_templatesFactory->create();
        $collection->addFieldToFilter('orig_template_code', $templateId);

        $collection->load();

        $options = $collection->toOptionArray();

        $templateLabel = $this->_emailConfig->getTemplateLabel($templateId);
        $templateLabel = __('%1 (Default)', $templateLabel);
        array_unshift($options, ['value' => $templateId, 'label' => $templateLabel]);

        return $options;
    }
}
