<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Model\Config\Source;

use Amasty\Dropshipping\Helper\Data as PermHelper;
use Amasty\Dropshipping\Model\ResourceModel\Dealer\CollectionFactory;
use Magento\Framework\Data\OptionSourceInterface;

class Dealers implements OptionSourceInterface
{
    /**
     * @var CollectionFactory
     */
    protected $_collectionFactory;

    /**
     * @var PermHelper
     */
    protected $_permHelper;

    public function __construct(
        CollectionFactory $collectionFactory,
        PermHelper $permHelper
    ) {
        $this->_permHelper = $permHelper;
        $this->_collectionFactory = $collectionFactory;
    }

    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        $optionArray = [];
        $arr = $this->toArray();
        foreach ($arr as $value => $label) {
            $optionArray[] = [
                'value' => $value,
                'label' => $label
            ];
        }

        return $optionArray;
    }

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray()
    {
        $collection = $this->_collectionFactory->create()->addUserData();

        return $collection->toUserOptionArray();
    }
}
