<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Controller\Adminhtml;

use Amasty\Dropshipping\Model\DealerFactory;
use Amasty\Dropshipping\Model\Mailer;
use Magento\Backend\App\Action;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\MailException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Sales\Api\OrderRepositoryInterface;

abstract class Massaction extends Action
{
    /**
     * @var DealerFactory
     */
    protected $dealerFactory;

    /**
     * @var Mailer
     */
    protected $mailer;

    /**
     * @var OrderRepositoryInterface
     */
    private $orderRepository;

    public function __construct(
        Action\Context $context,
        DealerFactory $dealerFactory,
        OrderRepositoryInterface $orderRepository,
        Mailer $mailer
    ) {
        $this->dealerFactory = $dealerFactory;
        $this->mailer = $mailer;
        $this->orderRepository = $orderRepository;
        parent::__construct($context);
    }

    /**
     * Authorization level of a basic admin session
     *
     * @see _isAllowed()
     */
    public const ADMIN_RESOURCE = 'Amasty_Dropshipping::massaction';

    /**
     * @param array $orderItemIds
     * @param int   $dealerId
     * @param int   $orderId
     *
     * @return void
     * @throws LocalizedException
     * @throws MailException
     * @throws NoSuchEntityException
     */
    protected function sendNotifications($orderItemIds, $dealerId, $orderId)
    {
        $dealer = $this->dealerFactory->create()->load($dealerId);
        $dealer->checkPermissions(); // get dealer info
        $order = $this->orderRepository->get((int)$orderId);
        $origOrderItems = $order->getItems();
        $dealerOrderItems = [];

        foreach ($origOrderItems as $key => $item) {
            if (in_array($item->getId(), $orderItemIds)) {
                $dealerOrderItems[] = $item;
            }
        }

        $order->setItems($dealerOrderItems);
        $this->mailer->send($dealer->getEmail(), $order);
        $order->setItems($origOrderItems);
    }
}
