<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Block\Adminhtml\Order\View\Tab;

use Amasty\Dropshipping\Model\ConfigProvider;
use Amasty\Dropshipping\Model\DealerOrder\AssignHistoryFactory;
use Amasty\Dropshipping\Model\Mailer;
use Amasty\Dropshipping\Model\ResourceModel\Dealer\CollectionFactory as DealerCollectionFactory;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magento\Sales\Block\Adminhtml\Order\AbstractOrder;

class Assign extends AbstractOrder implements TabInterface
{
    /**
     * @var \Amasty\Dropshipping\Helper\Data
     */
    protected $permHelper;

    /**
     * @var \Amasty\Dropshipping\Model\DealerOrderFactory
     */
    protected $dealerOrderFactory;

    /**
     * @var \Amasty\Dropshipping\Model\DealerOrder
     */
    protected $dealerOrder;

    /**
     * @var \Amasty\Dropshipping\Model\Config\Source\Dealers
     */
    protected $dealersConfig;

    /**
     * @var DealerCollectionFactory
     */
    private $dealerCollectionFactory;

    /**
     * @var AssignHistoryFactory
     */
    private $assignHistoryFactory;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Sales\Helper\Admin $adminHelper,
        \Amasty\Dropshipping\Helper\Data $permHelper,
        \Amasty\Dropshipping\Model\Config\Source\Dealers $dealersConfig,
        \Amasty\Dropshipping\Model\DealerOrderFactory $dealerOrderFactory,
        DealerCollectionFactory $dealerCollectionFactory,
        AssignHistoryFactory $assignHistoryFactory,
        ConfigProvider $configProvider,
        array $data = []
    ) {
        $this->permHelper = $permHelper;
        $this->dealersConfig = $dealersConfig;
        $this->dealerOrderFactory = $dealerOrderFactory;

        parent::__construct($context, $registry, $adminHelper, $data);
        $this->dealerCollectionFactory = $dealerCollectionFactory;
        $this->assignHistoryFactory = $assignHistoryFactory;
        $this->configProvider = $configProvider;
    }

    /**
     * Return Tab label
     *
     * @return string
     * @api
     */
    public function getTabLabel()
    {
        return __('Dealer Comments');
    }

    /**
     * Return Tab title
     *
     * @return string
     * @api
     */
    public function getTabTitle()
    {
        return $this->getTabLabel();
    }

    /**
     * Can show tab in tabs
     *
     * @return boolean
     * @api
     */
    public function canShowTab()
    {
        return true;
    }

    /**
     * Tab is hidden
     *
     * @return boolean
     * @api
     */
    public function isHidden()
    {
        return false;
    }

    public function getDealers()
    {
        return $this->dealersConfig->toArray();
    }

    public function isDealerNotificationNotApplicable(): bool
    {
        return !$this->configProvider->isNotifyEnabled((int)$this->getOrder()->getStoreId());
    }

    public function isFromToMode()
    {
        return $this->permHelper->isFromToMode();
    }

    public function isAuthorMode()
    {
        return $this->permHelper->isAuthorMode();
    }

    public function getDealerOrder()
    {
        if ($this->dealerOrder === null) {
            $this->dealerOrder = $this->dealerOrderFactory->create()->load($this->getOrder()->getId(), 'order_id');
        }
        return $this->dealerOrder;
    }

    protected function _prepareLayout()
    {
        $button = $this->getLayout()->createBlock(
            \Magento\Backend\Block\Widget\Button::class
        )->setData(
            [
                'label' => __('Submit Comment'),
                'class' => 'action-save action-secondary',
                'id'    => 'amasty-add-comment'
            ]
        );
        $this->setChild('submit_button', $button);
        return parent::_prepareLayout();
    }

    /**
     * @return bool
     */
    public function currentDealerId()
    {
        return $this->permHelper->getBackendDealerId();
    }

    /**
     * @return \Amasty\Dropshipping\Model\ResourceModel\Dealer\Collection
     */
    public function getDealerCollection()
    {
        $dealerCollection = $this->dealerCollectionFactory->create();
        if ($dealerId = $this->currentDealerId()) {
            $dealerCollection->addFieldToFilter('entity_id', $dealerId);
        }

        return $dealerCollection;
    }

    /**
     * @param int $dealerId
     * @param int $orderId
     *
     * @return mixed
     */
    public function getAssignedComments($dealerId, $orderId)
    {
        $collection = $this->assignHistoryFactory->create()
            ->getCollection()
            ->setOrder('created_at', 'desc')
            ->setOrder('entity_id', 'desc')
            ->addFieldToFilter('parent_id', $orderId)
            ->addFieldToFilter('to_dealer_id', $dealerId);

        return $collection;
    }

    public function getSubmitCommentUrl()
    {
        return $this->getUrl('amasty_perm/order/addDealerComment', ['order_id' => $this->getOrder()->getId()]);
    }
}
