<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Block\Adminhtml\Order\View\Items\Renderer;

use Amasty\Dropshipping\Helper\Data;
use Amasty\Dropshipping\Model\Config\Source\Dealers;
use Amasty\Dropshipping\Model\DealerItem\ResourceModel\DealerItem;
use Amasty\Dropshipping\Model\DealerOrderFactory;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\Registry;
use Magento\Sales\Block\Adminhtml\Order\AbstractOrder;
use Magento\Sales\Helper\Admin;

class DealerList extends AbstractOrder
{
    /**
     * @var Data
     */
    private $permHelper;

    /**
     * @var Dealers
     */
    private $dealersConfig;

    /**
     * @var \Amasty\Dropshipping\Model\DealerOrder
     */
    private $dealerOrder;

    /**
     * @var int $lastOrderItem
     */
    private $lastOrderItem;

    /**
     * @var int $dealerIdForItem
     */
    private $dealerIdForItem;

    /**
     * @var DealerOrderFactory
     */
    private $dealerOrderFactory;

    /**
     * @var DealerItem
     */
    private $dealerItemResource;

    public function __construct(
        Context $context,
        Registry $registry,
        Admin $adminHelper,
        Data $permHelper,
        Dealers $dealersConfig,
        DealerOrderFactory $dealerOrderFactory,
        DealerItem $dealerItemResource,
        array $data = []
    ) {
        parent::__construct($context, $registry, $adminHelper, $data);
        $this->permHelper = $permHelper;
        $this->dealersConfig = $dealersConfig;
        $this->dealerOrderFactory = $dealerOrderFactory;
        $this->dealerItemResource = $dealerItemResource;
    }

    public function getDealers()
    {
        return $this->dealersConfig->toArray();
    }

    public function getDealerOrder()
    {
        if ($this->dealerOrder === null) {
            $this->dealerOrder = $this->dealerOrderFactory->create()->load($this->getOrder()->getId(), 'order_id');
        }

        return $this->dealerOrder;
    }

    /**
     * @return int
     */
    public function getAssignedDealer()
    {
        return $this->dealerItemResource->getDealerIdByItemId($this->getOrderItemId());
    }

    /**
     * @param int $itemId
     *
     * @return $this
     */
    public function setOrderItemId($itemId)
    {
        return $this->setData('item_id', $itemId);
    }

    /**
     * @return int
     */
    public function getOrderItemId()
    {
        return $this->getData('item_id');
    }
}
