<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Block\Adminhtml\Order\View\Items\Renderer;

use Magento\Sales\Block\Adminhtml\Order\AbstractOrder;

class Assign extends AbstractOrder
{
    protected function _prepareLayout()
    {
        $button = $this->getLayout()->createBlock(
            \Magento\Backend\Block\Widget\Button::class
        )->setData(
            [
                'label' => __('Assign Dealers'),
                'class' => 'action-save action-secondary',
                'id'    => 'amasty-assign-dealers'
            ]
        );
        $this->setChild('submit_button', $button);

        return parent::_prepareLayout();
    }

    public function getSubmitUrl()
    {
        return $this->getUrl('amasty_perm/order/AssignDealer', ['order_id' => $this->getOrder()->getId()]);
    }
}
