<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */
namespace Amasty\Dropshipping\Block\Adminhtml\Dealer\Tab;

class Reports extends Tab
{
    protected function _construct()
    {
        parent::_construct();
        $this->setTemplate('dealer/reports.phtml');
    }

    public function getTabLabel()
    {
        return __('Reports');
    }

    protected function _prepareLayout()
    {
        $this->setChild(
            'dealerReportsGrid',
            $this->getLayout()
                ->createBlock(\Amasty\Dropshipping\Block\Adminhtml\Dealer\Grid\Reports::class, 'dealerReportsGrid')
                ->setDealer($this->_getDealer())
        );
        return parent::_prepareLayout();
    }

    public function getGridHtml()
    {
        return $this->getChildHtml('dealerReportsGrid');
    }
}
