<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */
namespace Amasty\Dropshipping\Block\Adminhtml\Dealer\Tab;

class Customers extends Tab
{
    /**
     * @var \Magento\User\Model\ResourceModel\User\CollectionFactory
     */
    protected $_userCollectionFactory;

    /**
     * @var \Amasty\Dropshipping\Model\DealerCustomerFactory
     */
    protected $_dealerCustomerFactory;

    /**
     * @var \Amasty\Dropshipping\Helper\Data
     */
    protected $_permHelper;

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Amasty\Dropshipping\Model\RoleFactory $roleFactory,
        \Amasty\Dropshipping\Model\DealerFactory $dealerFactory,
        \Amasty\Dropshipping\Helper\Data $permHelper,
        \Magento\User\Model\ResourceModel\User\CollectionFactory $userCollectionFactory,
        \Amasty\Dropshipping\Model\DealerCustomerFactory $dealerCustomerFactory,
        array $data = []
    ) {
        $this->_permHelper = $permHelper;
        $this->_userCollectionFactory = $userCollectionFactory;
        $this->_dealerCustomerFactory = $dealerCustomerFactory;
        parent::__construct($context, $registry, $formFactory, $roleFactory, $dealerFactory, $data);
    }

    protected function _construct()
    {
        parent::_construct();
        $this->setTemplate('dealer/customers.phtml');
    }

    public function getTabLabel()
    {
        return __('Manage Customers');
    }

    protected function _prepareLayout()
    {
        $this->setChild(
            'dealerCustomersGrid',
            $this->getLayout()
                ->createBlock(\Amasty\Dropshipping\Block\Adminhtml\Dealer\Grid\Customers::class, 'dealerCustomersGrid')
                ->setDealer($this->_getDealer())
        );
        return parent::_prepareLayout();
    }

    public function getGridHtml()
    {
        return $this->getChildHtml('dealerCustomersGrid');
    }

    public function isHidden()
    {
        return parent::isHidden() || $this->_permHelper->isEditNoGridMode();
    }
}
