<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Block\Adminhtml\Dealer\Grid;

use Magento\Framework\DB\Select;

class Reports extends \Magento\Backend\Block\Widget\Grid\Extended
{
    /**
     * @var \Magento\Framework\Registry|null
     */
    protected $_coreRegistry = null;

    /**
     * @var \Magento\Framework\Json\EncoderInterface
     */
    protected $_jsonEncoder;

    /**
     * @var \Magento\Framework\View\Element\UiComponent\DataProvider\CollectionFactory
     */
    protected $_collectionFactory;

    /**
     * @var \Amasty\Dropshipping\Model\DealerFactory
     */
    protected $_dealerFactory;

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Backend\Helper\Data $backendHelper,
        \Magento\Framework\Json\EncoderInterface $jsonEncoder,
        \Magento\Framework\Registry $coreRegistry,
        \Amasty\Dropshipping\Model\DealerFactory $dealerFactory,
        \Magento\Framework\View\Element\UiComponent\DataProvider\CollectionFactory $collectionFactory,
        array $data = []
    ) {

        parent::__construct($context, $backendHelper, $data);
        $this->_jsonEncoder = $jsonEncoder;
        $this->_coreRegistry = $coreRegistry;
        $this->_collectionFactory = $collectionFactory;
        $this->_dealerFactory = $dealerFactory;
    }

    protected function _construct()
    {
        parent::_construct();
        $this->setId('dealerReportsGrid');
        $this->setUseAjax(true);
    }

    protected function getNewFields()
    {
        $fields = [
            'base_grand_total',

            'base_discount_amount',
            'base_discount_canceled',
            'base_discount_invoiced',
            'base_discount_refunded',

            'base_shipping_amount',
            'base_shipping_canceled',
            'base_shipping_invoiced',
            'base_shipping_refunded',

            'base_shipping_tax_amount',
            'base_shipping_tax_refunded',

            'base_subtotal',
            'base_subtotal_canceled',
            'base_subtotal_invoiced',
            'base_subtotal_refunded',

            'base_tax_amount',
            'base_tax_canceled',
            'base_tax_invoiced',
            'base_tax_refunded'
        ];
        return $fields;
    }

    protected function _prepareCollection()
    {
        $orders =  $this->_collectionFactory->getReport('sales_order_grid_data_source');
        $connection = $orders->getConnection();
        $select = $orders->getSelect();
        $select->reset(Select::COLUMNS);

        $fields = ['increment_id', 'created_at', 'billing_name', 'shipping_name',
            'store_id', 'status', 'entity_id'];
        $map = [];
        foreach ($fields as $f) {
            $map['m_' . $f] = 'main_table.' . $f;
        }
        $select->from(null, $map);

        $fields = [];
        foreach ($this->getNewFields() as $f) {
            $fields['o_' . $f] = 'o.' . $f;
        }

        $select->joinInner(
            ['o'=>$orders->getTable('sales_order')],
            'o.entity_id=main_table.entity_id',
            $fields
        );

        $select->joinInner(
            ['dealer_order' => $orders->getTable('amasty_perm_dealer_order')],
            $connection->quoteInto(
                'dealer_order.order_id=main_table.entity_id and dealer_order.dealer_id = ?',
                (int)$this->getDealer()->getId()
            ),
            $fields
        );

        $this->setCollection($orders);

        return parent::_prepareCollection();
    }

    protected function _prepareColumns()
    {
        $this->addColumn('m_increment_id', [
            'header'       => __('Order #'),
            'width'        => '100',
            'index'        => 'm_increment_id',
            'filter_index' => 'main_table.increment_id'
        ]);

        $this->addColumn('m_created_at', [
            'header'       => __('Purchase On'),
            'index'        => 'm_created_at',
            'type'         => 'm_datetime',
            'filter_index' => 'main_table.created_at'
        ]);

        $this->addColumn('m_billing_name', [
            'header'       => __('Bill to Name'),
            'index'        => 'm_billing_name',
            'filter_index' => 'main_table.billing_name'
        ]);

        $this->addColumn('m_shipping_name', [
            'header'       => __('Shipped to Name'),
            'index'        => 'm_shipping_name',
            'filter_index' => 'main_table.billing_name'
        ]);

        foreach ($this->getNewFields() as $f) {
            $this->addColumn('o_' . $f, [
                'header'       => __(ucwords(str_replace('_', ' ', $f))),
                'index'        => 'o_' . $f,
                'type'         => 'currency',
                'currency'     => 'order_currency_code',
                'filter_index' => 'o.' . $f
            ]);
        }

        if ($this->_storeManager->isSingleStoreMode()) {
            $this->addColumn('store_id', [
                'header'       => __('Bought From'),
                'index'        => 'm_store_id',
                'filter_index' => 'main_table.store_id',
                'type'         => 'store',
                'store_view'   => true
            ]);
        }

        $this->addColumn('status', [
            'header'       => __('Status'),
            'index'        => 'm_status',
            'filter_index' => 'main_table.status',
            'type'         => 'options',
            'width'        => '70px'
        ]);

        $this->addColumn('action', [
            'header'    => __('Action'),
            'index'     => 'm_entity_id',
            'type'      => 'action',
            'filter'    => false,
            'sortable'  => false,
            'actions'   => [
                [
                    'caption' => __('View Order'),
                    'url'     => ['base'=>'sales/order/view'],
                    'field'   => 'order_id'
                ],
            ]
        ]);

        $this->addExportType('amasty_perm/dealer/reportsExportCsv', __('CSV'));

        return parent::_prepareColumns();
    }

    public function getGridUrl()
    {
        return $this->getUrl(
            'amasty_perm/dealer/editrolereportsgrid',
            ['user_id' => $this->getDealer()->getUserId()]
        );
    }

    public function getDealer()
    {
        $dealer = parent::getDealer();
        if ($dealer === null) {
            $userId = $this->getRequest()->getParam('user_id');
            $dealer = $this->_dealerFactory->create()->load($userId, 'user_id');
            $dealer->setUserId($userId);
        }
        return $dealer;
    }
}
