<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Api;

/**
 * @api
 */
interface DealerItemRepositoryInterface
{
    /**
     * Save
     *
     * @param \Amasty\Dropshipping\Api\Data\DealerItemInterface $dealerItem
     *
     * @return \Amasty\Dropshipping\Api\Data\DealerItemInterface
     */
    public function save(\Amasty\Dropshipping\Api\Data\DealerItemInterface $dealerItem);

    /**
     * Get by id
     *
     * @param int $entityId
     *
     * @return \Amasty\Dropshipping\Api\Data\DealerItemInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($entityId);

    /**
     * Delete
     *
     * @param \Amasty\Dropshipping\Api\Data\DealerItemInterface $dealerItem
     *
     * @return bool true on success
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(\Amasty\Dropshipping\Api\Data\DealerItemInterface $dealerItem);

    /**
     * Delete by id
     *
     * @param int $entityId
     *
     * @return bool true on success
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($entityId);

    /**
     * Lists
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Magento\Framework\Api\SearchResultsInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getList(\Magento\Framework\Api\SearchCriteriaInterface $searchCriteria);
}
