<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Dropshipping for Magento 2
 */

namespace Amasty\Dropshipping\Api\Data;

interface DealerItemInterface
{
    public const ENTITY_ID = 'entity_id';
    public const DEALER_ID = 'dealer_id';
    public const ORDER_ITEM_ID = 'order_item_id';
    public const NOTIFIED = 'notified';

    /**
     * @return int
     */
    public function getEntityId();

    /**
     * @param int $entityId
     *
     * @return \Amasty\Dropshipping\Api\Data\DealerItemInterface
     */
    public function setEntityId($entityId);

    /**
     * @return int|null
     */
    public function getDealerId();

    /**
     * @param int|null $dealerId
     *
     * @return \Amasty\Dropshipping\Api\Data\DealerItemInterface
     */
    public function setDealerId($dealerId);

    /**
     * @return int
     */
    public function getOrderItemId();

    /**
     * @param int $orderItemId
     *
     * @return \Amasty\Dropshipping\Api\Data\DealerItemInterface
     */
    public function setOrderItemId($orderItemId);

    /**
     * @return bool
     */
    public function getNotifyStatus();

    /**
     * @param bool $notified
     *
     * @return \Amasty\Dropshipping\Api\Data\DealerItemInterface
     */
    public function setNotifyStatus($notified);
}
