define([
    'moment',
    'ko',
    'underscore',
    'jquery',
    'mage/translate',
    'mage/calendar'
], function (moment, ko, _, $, $t) {
    'use strict';

    var defaults = {
            dateFormat: 'mm\/dd\/yyyy',
            showsTime: false,
            timeFormat: null,
            buttonImage: null,
            showOn: 'both',
            buttonImageOnly: false,
            yearRange: 'c+0:c+1',
            drawYear: new Date().getFullYear(),
            drawMonth: new Date().getMonth() + 1,
            minDate: 0,
            buttonText: $t('Select Date'),
            currentText: $t('First Available Day')
        },
        map = {
            'D': 'd',
            'M': 'm'
        };

    ko.bindingHandlers.amastydatepicker = {
        init: function (element, valueAccessor) {
            var config = valueAccessor(),
                observable,
                $element = $(element),
                options = {},
                updateDate = function () {
                    let momentDate = moment(observable(), config.elem.pickerDateTimeFormat);
                    $element.datepicker('setDate', momentDate.toDate());
                };

            _.extend(options, defaults);

            if (typeof config === 'object') {
                observable = config.storage;

                _.extend(options, config.options);
            } else {
                observable = config;
            }

            /*
             * Prepare format for calendar lib.
             * notice: it is not last prepare. in calendar.js short year pattern will be transferred to long.
             *      Always long year format on frontend.
             */
            _.each(map, function (momentFormat, mage) {
                options.dateFormat = options.dateFormat.replace(new RegExp(mage, 'g'), momentFormat);
            });

            // initialize datepicker
            $element.calendar(options);

            // set initial calendar value (default)
            if (observable()) {
                updateDate();
            }

            $element.blur();

            ko.utils.registerEventHandler(element, 'change', function () {
                observable(this.value);

                if (this.value !== observable()) {
                    updateDate();
                }
            });
        }
    };
});
