<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Delivery Date Manager for Magento 2
 */

namespace Amasty\DeliveryDateManager\Ui\Component\Form\Channel;

class ConfigurationWebsitesProvider implements \Magento\Framework\Data\OptionSourceInterface
{
    /**
     * @var \Magento\Store\Model\System\Store
     */
    private $systemStore;

    public function __construct(\Magento\Store\Model\System\Store $systemStore)
    {
        $this->systemStore = $systemStore;
    }

    /**
     * @return array
     */
    public function toOptionArray()
    {
        return $this->systemStore->getStoreValuesForForm();
    }
}
