<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Delivery Date Manager for Magento 2
 */

namespace Amasty\DeliveryDateManager\Plugin\Sales\Model\Order\Email\Sender\OrderSender;

use Amasty\DeliveryDateManager\Model\DeliveryOrder\LoaderExtensions;
use Magento\Sales\Model\Order;
use Magento\Sales\Model\Order\Email\Sender\OrderSender;

class LoadExtensionAttributes
{
    /**
     * @var LoaderExtensions
     */
    private $loaderExtensions;

    public function __construct(
        LoaderExtensions $loaderExtensions
    ) {
        $this->loaderExtensions = $loaderExtensions;
    }

    /**
     * @param OrderSender $subject
     * @param Order $order
     * @param bool $forceSyncMode
     */
    public function beforeSend(OrderSender $subject, Order $order, $forceSyncMode = false)
    {
        $this->loaderExtensions->loadDeliveryDateExtensionAttributes($order);
    }
}
