<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Delivery Date Manager for Magento 2
 */

namespace Amasty\DeliveryDateManager\Model\TimeInterval;

class TimeToMinsConverter
{
    public const FIRST_UNIX_DAY = '01 Jan 1970 GMT ';

    /**
     * @param string $time
     * @return int
     */
    public function execute(string $time): int
    {
        return (int)strtotime(self::FIRST_UNIX_DAY . $time) / 60;
    }
}
