<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Delivery Date Manager for Magento 2
 */

namespace Amasty\DeliveryDateManager\Model\Relations\TimeIntervalChannelRelation;

use Amasty\DeliveryDateManager\Api\Data\TimeIntervalChannelRelationInterface;
use Amasty\DeliveryDateManager\Model\ResourceModel\TimeIntervalChannelRelation;

class Delete
{
    /**
     * @var TimeIntervalChannelData
     */
    private $resourceModel;

    public function __construct(TimeIntervalChannelRelation $resourceModel)
    {
        $this->resourceModel = $resourceModel;
    }

    public function deleteByRelation(TimeIntervalChannelRelationInterface $relation): void
    {
        $this->resourceModel->delete($relation);
    }
}
