<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Delivery Date Manager for Magento 2
 */

namespace Amasty\DeliveryDateManager\Model\DeliveryChannel;

use Amasty\DeliveryDateManager\Api\Data\DeliveryChannelSearchResultsInterface;
use Magento\Framework\Api\SearchResults;

/**
 * @method \Amasty\DeliveryDateManager\Api\Data\DeliveryChannelInterface[] getItems()
 */
class DeliveryChannelSearchResults extends SearchResults implements DeliveryChannelSearchResultsInterface
{
    /**
     * @return int[]
     */
    public function getIds(): array
    {
        $ids = [];
        foreach ($this->getItems() as $item) {
            $ids[] = $item->getChannelId();
        }

        return $ids;
    }
}
