<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Delivery Date Manager for Magento 2
 */

namespace Amasty\DeliveryDateManager\Block\Component;

interface ComponentInterface
{
    /**
     * @return string
     */
    public function getName(): string;
    
    /**
     * @param int $storeId
     * @return array
     */
    public function getComponent(int $storeId): array;

    /**
     * @param int $storeId
     * @return bool
     */
    public function isEnabled(int $storeId): bool;
}
