<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Delivery Date Manager for Magento 2
 */

namespace Amasty\DeliveryDateManager\Api;

/**
 * Delivery channel search criteria scope processor
 */
interface DeliveryChannelScopeProcessorInterface
{
    /**
     * Process Scope Search Criteria.
     * Add scope filters.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     */
    public function processSearchCriteria(\Magento\Framework\Api\SearchCriteriaInterface $searchCriteria): void;
}
