<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/
declare(strict_types=1);

namespace Amasty\Segments\Ui\DataProvider\Segment;

use Amasty\Segments\Api\Data\SegmentInterface;
use Amasty\Segments\Model\ResourceModel\Segment\CollectionFactory;
use Magento\Ui\DataProvider\AbstractDataProvider;

class ListingDataProvider extends AbstractDataProvider
{
    public function __construct(
        CollectionFactory $collectionFactory,
        $name,
        $primaryFieldName,
        $requestFieldName,
        array $meta = [],
        array $data = []
    ) {
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
        $this->collection = $collectionFactory->create()->joinStoreRelationTable();
    }

    public function addFilter(\Magento\Framework\Api\Filter $filter)
    {
        if ($filter->getField() == SegmentInterface::SEGMENT_ID) {
            $filter->setField('main_table.' . SegmentInterface::SEGMENT_ID);
        }

        parent::addFilter($filter);
    }
}
