<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/

namespace Amasty\Segments\Ui\DataProvider\Customer;

use Magento\Framework\App\RequestInterface;
use Amasty\Segments\Model\ResourceModel\Customer\CollectionFactory;
use Amasty\Segments\Model\ResourceModel\Customer\Collection;

class CustomerDataProvider extends \Amasty\Segments\Ui\DataProvider\Customer\AbstractDataProvider
{

    public const FIELD_MAP = [
        'email' => 'main_table.email',
        'created_at' => 'main_table.created_at',
        'firstname' => 'main_table.firstname',
        'lastname' => 'main_table.lastname',
        'group_id' => 'main_table.group_id',
        'default_billing' => 'main_table.default_billing',
        'telephone' => 'address.telephone',
        'country_id' => 'address.country_id',
        'region' => 'address.region'
    ];

    // phpcs:ignore Generic.CodeAnalysis.UselessOverridingMethod.Found
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        \Amasty\Segments\Model\ResourceModel\Customer\CollectionFactory $collectionFactory,
        RequestInterface $request,
        \Amasty\Segments\Model\SegmentRepository $segmentRepository,
        \Magento\Framework\Api\Search\SearchCriteriaBuilder $searchCriteriaBuilder,
        array $meta = [],
        array $data = []
    ) {
        parent::__construct(
            $name,
            $primaryFieldName,
            $requestFieldName,
            $collectionFactory,
            $request,
            $segmentRepository,
            $searchCriteriaBuilder,
            $meta,
            $data
        );
    }

    /**
     * @param \Magento\Framework\Api\Filter $filter
     */
    public function addFilter(\Magento\Framework\Api\Filter $filter)
    {
        if (array_key_exists($filter->getField(), self::FIELD_MAP)) {
            $filter->setField(self::FIELD_MAP[$filter->getField()]);
        }
        parent::addFilter($filter);
    }
}
