<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/

namespace Amasty\Segments\Plugin;

class TabLabel
{
    public const CUSTOMERS_FIELDSET_NAMESPACE = 'customer';

    public const GUESTS_FIELDSET_NAMESPACE = 'guest';

    /**
     * @var \Amasty\Segments\Helper\Customer\Data
     */
    protected $customerHelper;

    /**
     * TabLabel constructor.
     * @param \Amasty\Segments\Helper\Customer\Data $customerHelper
     */
    public function __construct(
        \Amasty\Segments\Helper\Customer\Data $customerHelper
    ) {
        $this->customerHelper = $customerHelper;
    }

    /**
     * @param \Magento\Ui\Component\Form\Fieldset $subject
     * @param $result
     * @return \Magento\Framework\Phrase
     */
    public function afterGetComponentName(\Magento\Ui\Component\Form\Fieldset $subject, $result)
    {
        $subjectName = $subject->getName();

        if (in_array($subjectName, [self::CUSTOMERS_FIELDSET_NAMESPACE, self::GUESTS_FIELDSET_NAMESPACE], true)) {
            $collection = $this->customerHelper->{'getFiltered' . ucfirst($subjectName) . 'Collection'}();
            $configs = $subject->getConfig();

            if (!array_key_exists('is_modified', $configs)) {
                $configs['label'] = __(sprintf($configs['label'] . ' (%s)', $collection->getSize()));
                $configs['is_modified'] = 1;
                $subject->setConfig($configs);
            }
        }

        return $result;
    }
}
