<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/

namespace Amasty\Segments\Plugin\Customer\Model\ResourceModel\Address\Collection;

use Amasty\Segments\Model\BatchLoader;
use Magento\Customer\Model\ResourceModel\Address\Collection;

class BatchLoad
{
    /**
     * @var BatchLoader
     */
    private $batchLoader;

    public function __construct(
        BatchLoader $batchLoader
    ) {
        $this->batchLoader = $batchLoader;
    }

    public function aroundGetIterator(Collection $subject, callable $proceed): \Generator
    {
        return $this->batchLoader->load($subject);
    }
}
