<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/

namespace Amasty\Segments\Observer\Admin;

use Amasty\Segments\Model\Rule\Condition\Segment;
use Magento\Framework\Event\ObserverInterface;

class AddNewConditionHandle implements ObserverInterface
{
    /**
     * @param \Magento\Framework\Event\Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $additional = $observer->getAdditional();
        $conditions = $additional->getConditions();

        if (!is_array($conditions)) {
            $conditions = [];
        }

        $conditions[] = [
            'label' => __('Customers Segmentation'),
            'value' => [
                [
                    'value' => Segment::class,
                    'label' => __('Segments'),
                ]
            ]
        ];
        $additional->setConditions($conditions);
    }
}
