<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Customer Segmentation for Magento 2
*/
declare(strict_types=1);

namespace Amasty\Segments\Model;

use Amasty\Base\Model\Serializer;
use Amasty\Segments\Model\ResourceModel\Index;
use Amasty\Segments\Model\Rule\Condition\CombineFactory;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;
use Magento\Framework\Stdlib\DateTime\TimezoneInterface;
use Magento\Rule\Model\AbstractModel;
use Magento\Rule\Model\Action\Collection;
use Magento\Rule\Model\Action\CollectionFactory;
use Magento\Rule\Model\Condition\Combine;

class SalesRule extends AbstractModel
{
    /**
     * @var CombineFactory
     */
    protected $condCombineFactory;

    /**
     * @var CollectionFactory
     */
    protected $actionCollectionFactory;

    /**
     * @var ResourceModel\Index
     */
    protected $indexResource;

    /**
     * @var Serializer
     */
    protected $serializer;

    public function __construct(
        Context $context,
        Registry $registry,
        FormFactory $formFactory,
        TimezoneInterface $localeDate,
        Serializer $serializer,
        Index $indexResource,
        CombineFactory $condCombineFactory,
        CollectionFactory $actionCollectionFactory,
        AbstractResource $resource = null,
        AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        parent::__construct(
            $context,
            $registry,
            $formFactory,
            $localeDate,
            $resource,
            $resourceCollection,
            $data
        );
        $this->serializer = $serializer;
        $this->indexResource = $indexResource;
        $this->condCombineFactory = $condCombineFactory;
        $this->actionCollectionFactory = $actionCollectionFactory;
    }

    protected function _construct()
    {
        parent::_construct();

        $this->_init(\Amasty\Segments\Model\ResourceModel\Segment::class);
        $this->setIdFieldName('segment_id');
    }

    /**
     * Get rule condition combine model instance
     *
     * @return Combine
     */
    public function getConditionsInstance(): Combine
    {
        return $this->condCombineFactory->create();
    }

    /**
     * @return Collection
     */
    public function getActionsInstance(): Collection
    {
        return $this->actionCollectionFactory->create();
    }

    /**
     * @param string $type
     * @param array $segments
     * @param string|int $entityId
     * @return bool
     */
    public function validateByIndex($type, $segments, $entityId): bool
    {
        $segmentItems = $this->indexResource->checkValidCustomerFromIndex($segments, $entityId, $type);

        return count($segmentItems) > 0;
    }

    /**
     * @param string $formName
     * @return string
     */
    public function getConditionsFieldSetId(string $formName = ''): string
    {
        return $formName . 'rule_conditions_fieldset_' . $this->getId();
    }

    /**
     * @param string $formName
     * @return string
     */
    public function getActionsFieldSetId(string $formName = ''): string
    {
        return $formName . 'rule_actions_fieldset_' . $this->getId();
    }
}
